% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022

% Create model data to replicate Figure 3

% Exogenously vary PI and obtain the marginal effect of variations in PI on Atilde
% Set up options for constrained optimization
options                             = optimset('fmincon');
options                             = optimset(options,'Display','off'); % No display
PIGRID                              = linspace(0,1,200);
Aineq                               = zeros(PARMS.N-1,PARMS.N);
Aineq(1:(PARMS.N-1)+1:end)          = 1;
Aineq(PARMS.N:(PARMS.N-1)+1:end)    = -1;
bineq                               = zeros(PARMS.N-1,1);
lb                                  = zeros(PARMS.N,1);
Aeq                                 = PARMS.PP';
beq                                 = 1; %
A                                   = 1;
k_ini                               = ones(PARMS.N,1); 

% Pre-allocate matrices
SR_vec                              = zeros(length(PIGRID),1); 
dSR_dPI_vec                         = zeros(length(PIGRID),1); 

% Go through all exogenous values of PI
for pp = 1:length(PIGRID)
    
    pistar  = PIGRID(pp);
    
    % Search for the optimal capital allocation GIVEN that pi = PIGRID(pp)
    k_static            = fmincon(@(x) static_solution_fixedpi(x,pistar,A,PARMS),k_ini,Aineq,bineq,Aeq,beq,lb,[],[],options);   
    
    % Back out Solow residual and the marginal effect of PI
    [~, SR, dSR_dPI]    = static_solution_fixedpi(k_static,pistar,A,PARMS);
    
    k_ini               = k_static; % update initial guess
    
    % Solow residual
    SR_vec(pp)          = SR;
    % Marginal effect on Solow residual
    dSR_dPI_vec(pp)     = dSR_dPI;

end

% Find value on grid closest to calibration target
pi_ss           = steady.pistar;
[~, pi_star]    = min(abs(PIGRID-pi_ss));

% Steady state value of the SR:
SR_now          = SR_vec(pi_star); 
% Steady state value of the slope:
dSR_dPI_ss     = dSR_dPI_vec(pi_star); 

% Save the data in a CSV file
writematrix(PIGRID,sprintf('%s/PIGRID.csv',PARMS.figfolder))
writematrix(pi_ss,sprintf('%s/pi_ss.csv',PARMS.figfolder))
writematrix(dSR_dPI_ss,sprintf('%s/dSR_dPI_ss.csv',PARMS.figfolder))
writematrix(dSR_dPI_vec,sprintf('%s/dSR_dPI_vec.csv',PARMS.figfolder))
